// jQuery plugin - Dolphin RSS Aggregator
(function($){
	$.fn.dolRSSFeed = function(sForceUrl) {
		return this.each( function(){
			
			var $Cont = $(this);
			var iRSSID = $Cont.attr( 'rssid' );
			if( !iRSSID && sForceUrl == undefined )
				return false;
			
			var iMaxNum = parseInt( $Cont.attr( 'rssnum' ) || 0 );
			var iMemID  = parseInt( $Cont.attr( 'member' ) || 0 );

			var sFeedURL = (sForceUrl != undefined) ? sForceUrl : site_url + 'get_rss_feed.php?ID=' + iRSSID + '&member=' + iMemID;

			$Cont.bx_loading(true);

            $.getFeed( {
				url: sFeedURL,
				success: function(feed) {

					if (feed != undefined && feed.items) {
						var sCode =
							'<div class="rss_feed_wrapper bx-def-bc-margin">';
						var sTarget, iCount = 0;
						for( var iItemId = 0; iItemId < feed.items.length; iItemId ++ ) {
							var item = feed.items[iItemId];
							var sDate = '', oDate, a;

                            if (null != (a = item.updated.match(/(\d+)-(\d+)-(\d+)T(\d+):(\d+):(\d+)Z/))) {
                                oDate = new Date( a[1], a[2]-1, a[3], a[4], a[5], a[6], 0 );
                                sDate = oDate.toLocaleString();
                            } else if (item.updated.length > 0) {
    							oDate = new Date(item.updated.replace(/z$/i, "-00:00"));
                                sDate = isNaN(oDate) ? '' : oDate.toLocaleString();
                            }

                            sTarget = '';
                            if (item.link.substring(0, site_url.length) != site_url) // open external links in new window
                                sTarget = 'target="_blank"';
                            
							sCode +=
								'<hr class="bx-def-hr bx-def-margin-sec-top bx-def-margin-sec-bottom" />' +
								'<div class="rss_item_wrapper">' +
									'<div class="rss_item_header bx-def-font-h2">' +
										'<a href="' + item.link + '" ' + sTarget + '>' + item.title + '</a>' +
									'</div>' +
									'<div class="rss_item_desc">' + item.description + '</div>' +
									'<div class="rss_item_info bx-def-font-small bx-def-font-grayed">' +
										'<span>' +
											sDate +
										'</span>' +
									'</div>' +
								'</div>';
							
							iCount ++;
							if( iCount == iMaxNum )
								break;
						}
						
                        sTarget = '';
                        if (feed.link.substring(0, site_url.length) != site_url) // open external links in new window
                            sTarget = 'target="_blank"';

						sCode +=
							'</div>' +
                            
                            '<div class="rss_read_more bx-def-padding-left bx-def-padding-right">' +
                                '<a href="' + feed.link + '" ' + sTarget + ' class="rss_read_more_link">' + feed.title + '</a>' +
                            '</div>' +
                            
                            '<div class="clear_both"></div>';
						
						$Cont.html( sCode );
					}
				}
			} );
			
		} );
	};
})(jQuery);
